/*
 * Decompiled with CFR 0.152.
 */
package com.mcprog.ragnar.world;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import com.mcprog.ragnar.lib.Assets;

public class Player {
    private Body body;
    private BodyDef bodyDef;
    private Vector2 position;
    private World world;
    private int direction;
    private Vector2 touch;
    private float stamina;
    private float invincibleTimer = 10.0f;
    public boolean invincible;
    private ShapeRenderer shapeRenderer;
    private int accelerometerLimit = 15;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    public static final int LEFT_IDLE = 4;
    public static final int RIGHT_IDLE = 5;
    public static final int UP_IDLE = 6;
    public static final int DOWN_IDLE = 7;
    public static final int LEFT_BLOCK = 8;
    public static final int RIGHT_BLOCK = 9;
    public static final int UP_BLOCK = 10;
    public static final int DOWN_BLOCK = 11;

    public Player(World world, Vector2 position) {
        this.world = world;
        this.position = position;
        this.shapeRenderer = new ShapeRenderer();
        this.shapeRenderer.setAutoShapeType(true);
        this.touch = position;
        this.bodyDef = new BodyDef();
        this.bodyDef.type = BodyDef.BodyType.DynamicBody;
        this.bodyDef.position.set(position);
        this.body = world.createBody(this.bodyDef);
        this.body.setUserData(Assets.playerAnimations);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(0.6f, 1.0f);
        this.body.setFixedRotation(true);
        this.body.createFixture(shape, 1.0f);
        shape.dispose();
    }

    public void update(float delta) {
        this.handleInput();
    }

    public void handleInput() {
        if (Gdx.app.getType().equals((Object)Application.ApplicationType.Android) || Gdx.app.getType().equals((Object)Application.ApplicationType.iOS)) {
            if (Gdx.input.getPitch() > (float)this.accelerometerLimit) {
                this.body.setLinearVelocity(-8.0f, 0.0f);
                this.direction = 0;
            }
            if (Gdx.input.getPitch() < (float)(-this.accelerometerLimit)) {
                this.body.setLinearVelocity(8.0f, 0.0f);
                this.direction = 1;
            }
            if (Gdx.input.getRoll() > (float)this.accelerometerLimit) {
                this.body.setLinearVelocity(0.0f, 8.0f);
                this.direction = 2;
            }
            if (Gdx.input.getRoll() < (float)(-this.accelerometerLimit)) {
                this.body.setLinearVelocity(0.0f, -8.0f);
                this.direction = 3;
            }
            if (Math.abs(Gdx.input.getPitch()) <= (float)this.accelerometerLimit && Math.abs(Gdx.input.getRoll()) <= (float)this.accelerometerLimit) {
                this.body.setLinearVelocity(Vector2.Zero);
            }
        } else {
            if (Gdx.input.isKeyPressed(29) || Gdx.input.isKeyPressed(21)) {
                this.body.setLinearVelocity(-8.0f, 0.0f);
                this.direction = 0;
            }
            if (Gdx.input.isKeyPressed(32) || Gdx.input.isKeyPressed(22)) {
                this.body.setLinearVelocity(8.0f, 0.0f);
                this.direction = 1;
            }
            if (Gdx.input.isKeyPressed(51) || Gdx.input.isKeyPressed(19)) {
                this.body.setLinearVelocity(0.0f, 8.0f);
                this.direction = 2;
            }
            if (Gdx.input.isKeyPressed(47) || Gdx.input.isKeyPressed(20)) {
                this.body.setLinearVelocity(0.0f, -8.0f);
                this.direction = 3;
            }
            if (!(Gdx.input.isKeyPressed(51) || Gdx.input.isKeyPressed(19) || Gdx.input.isKeyPressed(29) || Gdx.input.isKeyPressed(21) || Gdx.input.isKeyPressed(47) || Gdx.input.isKeyPressed(20) || Gdx.input.isKeyPressed(32) || Gdx.input.isKeyPressed(22))) {
                this.body.setLinearVelocity(Vector2.Zero);
                if (this.direction != 4 && this.direction != 5 && this.direction != 6 && this.direction != 7 && !Gdx.input.isKeyPressed(59)) {
                    switch (this.direction) {
                        case 0: {
                            this.direction = 4;
                            break;
                        }
                        case 8: {
                            this.direction = 4;
                            break;
                        }
                        case 1: {
                            this.direction = 5;
                            break;
                        }
                        case 9: {
                            this.direction = 5;
                            break;
                        }
                        case 2: {
                            this.direction = 6;
                            break;
                        }
                        case 10: {
                            this.direction = 6;
                            break;
                        }
                        case 3: {
                            this.direction = 7;
                            break;
                        }
                        case 11: {
                            this.direction = 7;
                            break;
                        }
                    }
                }
            }
        }
    }

    public Vector2 getVelocity() {
        return this.body.getLinearVelocity();
    }

    public Vector2 getPosition() {
        return this.body.getPosition();
    }

    public int getDirection() {
        return this.direction;
    }

    public Body getBody() {
        return this.body;
    }
}

