/*
 * Decompiled with CFR 0.152.
 */
package com.mcprog.ragnar.world;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;

public class Arrow {
    private World world;
    private BodyDef bodyDef;
    private Vector2 position;
    private Sprite sprite;
    private Body body;
    private Vector2 movementRaw;

    public Arrow(World world, Vector2 position, float rotation) {
        this.world = world;
        this.bodyDef = new BodyDef();
        this.bodyDef.type = BodyDef.BodyType.DynamicBody;
        this.position = position;
        this.bodyDef.position.set(position);
        this.body = world.createBody(this.bodyDef);
        this.sprite = new Sprite(new Texture(Gdx.files.internal("arrow.png")));
        this.body.setUserData(this.sprite);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(1.5f, 0.15f);
        this.body.setFixedRotation(true);
        this.body.setTransform(position, rotation);
        this.body.createFixture(shape, 1.0f);
        shape.dispose();
        this.movementRaw = new Vector2((float)(-Math.cos(rotation)), (float)(-Math.sin(rotation)));
        this.movementRaw.scl((float)(Math.random() * 5.0) + 15.0f);
        this.body.setLinearVelocity(this.movementRaw);
    }

    public Body getBody() {
        return this.body;
    }
}

