/*
 * Decompiled with CFR 0.152.
 */
package com.mcprog.ragnar.screens;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.mcprog.ragnar.Ragnar;
import com.mcprog.ragnar.lib.Assets;

public class KillScreen
implements Screen {
    private Ragnar game;
    private SpriteBatch batch;
    public String deathMsg;
    private OrthographicCamera camera;

    public KillScreen(Ragnar gameInstance) {
        this.game = gameInstance;
        this.camera = new OrthographicCamera();
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(1.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        if (Gdx.app.getType().equals((Object)Application.ApplicationType.Android) || Gdx.app.getType().equals((Object)Application.ApplicationType.iOS)) {
            Assets.ragnarFont.drawMultiLine(this.batch, String.valueOf(this.deathMsg) + "\nTap screen to retry\nYou lasted " + (int)this.game.gameScreen.timeInGame + " seconds", -this.camera.viewportWidth * 0.375f, this.camera.viewportHeight * 0.25f);
        } else {
            Assets.ragnarFont.drawMultiLine(this.batch, String.valueOf(this.deathMsg) + "\nHit \"R\" to retry\nYou lasted " + (int)this.game.gameScreen.timeInGame + " seconds", -this.camera.viewportWidth * 0.375f, this.camera.viewportHeight * 0.25f);
        }
        this.batch.end();
        if (Gdx.input.isKeyJustPressed(46)) {
            this.game.gameScreen.timeInGame = 0.0f;
            this.game.setScreen(this.game.gameScreen);
        }
        if ((Gdx.app.getType().equals((Object)Application.ApplicationType.Android) || Gdx.app.getType().equals((Object)Application.ApplicationType.Android)) && Gdx.input.justTouched()) {
            this.game.gameScreen.timeInGame = 0.0f;
            this.game.setScreen(this.game.gameScreen);
        }
    }

    @Override
    public void resize(int width, int height) {
        this.camera.viewportWidth = width;
        this.camera.viewportHeight = height;
        this.camera.update();
    }

    @Override
    public void show() {
        this.batch = new SpriteBatch();
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }
}

