/*
 * Decompiled with CFR 0.152.
 */
package com.mcprog.ragnar.screens;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.mcprog.ragnar.Ragnar;
import com.mcprog.ragnar.lib.Assets;
import com.mcprog.ragnar.world.ArrowSpawner;
import com.mcprog.ragnar.world.Bounds;
import com.mcprog.ragnar.world.Player;

public class GameScreen
implements Screen,
ContactListener {
    private World world;
    private Ragnar game;
    private SpriteBatch batch;
    private SpriteBatch fontBatch;
    private OrthographicCamera camera;
    private OrthographicCamera fontCamera;
    private Box2DDebugRenderer renderer;
    private Array<Body> bodies;
    private TextureRegion frame;
    private Sprite frameSprite;
    private Player player;
    private ArrowSpawner spawner;
    private float stateTime;
    private float spawnTimer;
    private Array<Body> bodiesToDelete;
    public float timeBetweenArrows = 1.0f;
    private Bounds bounds;
    public float timeInGame;

    public GameScreen(Ragnar gameInstance) {
        this.game = gameInstance;
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.timeInGame += delta;
        this.world.step(0.016666668f, 8, 3);
        this.world.getBodies(this.bodies);
        if (!this.world.isLocked()) {
            int i = 0;
            while (i < this.bodiesToDelete.size) {
                if (this.bodiesToDelete.get(i) != null) {
                    this.world.destroyBody(this.bodiesToDelete.get(i));
                }
                this.bodiesToDelete.removeIndex(i);
                ++i;
            }
        }
        this.stateTime += delta;
        this.player.update(delta);
        this.spawnTimer += delta;
        if (this.spawnTimer > this.timeBetweenArrows) {
            this.spawner.spawn();
            this.spawnTimer = 0.0f;
            if ((double)this.timeBetweenArrows > 0.5) {
                this.timeBetweenArrows = (float)((double)this.timeBetweenArrows - 0.001);
            } else {
                System.out.println("Done");
            }
        }
        if (this.player.getBody().getWorldCenter().x < -this.camera.viewportWidth / 2.0f || this.player.getBody().getWorldCenter().x > this.camera.viewportWidth / 2.0f || this.player.getBody().getWorldCenter().y > this.camera.viewportHeight / 2.0f || this.player.getBody().getWorldCenter().y < -this.camera.viewportHeight / 2.0f) {
            this.game.setToKillScreen("You got too close to the english and they speared you");
        }
        this.batch.setProjectionMatrix(this.fontCamera.combined);
        this.batch.begin();
        Assets.scoreFont.draw(this.batch, "Score: " + (int)this.timeInGame, -this.fontCamera.viewportWidth / 2.0f * 0.97f, this.fontCamera.viewportHeight / 2.0f * 0.96f);
        this.batch.end();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        for (Body b : this.bodies) {
            Animation[] animations;
            if (b.getUserData() instanceof Sprite) {
                Sprite spr = (Sprite)b.getUserData();
                if (spr == null) continue;
                spr.setOrigin(spr.getWidth() / 2.0f, spr.getHeight() / 2.0f);
                spr.setBounds(b.getPosition().x - spr.getWidth() / 2.0f, b.getPosition().y - spr.getHeight() / 2.0f, 3.0f, 0.5f);
                spr.setRotation(b.getAngle() * 57.295776f);
                spr.draw(this.batch);
                continue;
            }
            if (!(b.getUserData() instanceof Animation[]) || (animations = (Animation[])b.getUserData()) == null) continue;
            this.frame = animations[this.player.getDirection()].getKeyFrame(this.stateTime, true);
            this.frameSprite = new Sprite(this.frame);
            this.frameSprite.setCenter(b.getPosition().x, b.getPosition().y);
            this.frameSprite.setScale(0.125f);
            this.frameSprite.draw(this.batch);
        }
        this.batch.end();
    }

    @Override
    public void resize(int width, int height) {
        if (Gdx.app.getType().equals((Object)Application.ApplicationType.Android) || Gdx.app.getType().equals((Object)Application.ApplicationType.iOS)) {
            this.camera.viewportWidth = width / 32;
            this.camera.viewportHeight = height / 32;
            this.camera.update();
            this.fontCamera.viewportWidth = width / 2;
            this.fontCamera.viewportHeight = height / 2;
            this.fontCamera.update();
        } else {
            this.camera.viewportWidth = width / 16;
            this.camera.viewportHeight = height / 16;
            this.camera.update();
            this.fontCamera.viewportWidth = width;
            this.fontCamera.viewportHeight = height;
            this.fontCamera.update();
        }
    }

    @Override
    public void show() {
        this.batch = new SpriteBatch();
        this.fontBatch = new SpriteBatch();
        this.world = new World(Vector2.Zero, true);
        this.camera = new OrthographicCamera();
        this.fontCamera = new OrthographicCamera();
        this.renderer = new Box2DDebugRenderer();
        this.bodies = new Array();
        this.player = new Player(this.world, Vector2.Zero);
        this.spawner = new ArrowSpawner(this.world, this.player);
        this.bounds = new Bounds(this.world);
        this.bodiesToDelete = new Array();
        this.world.setContactListener(this);
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void beginContact(Contact contact) {
        Fixture a = contact.getFixtureA();
        Fixture b = contact.getFixtureB();
        if (a.getBody() != null && b.getBody() != null && a.getBody().getUserData() instanceof Sprite) {
            this.bodiesToDelete.add(a.getBody());
        }
        if (a.getBody() != null && b.getBody() != null && b.getBody().getUserData() instanceof Sprite) {
            this.bodiesToDelete.add(b.getBody());
        }
        if ((a.getBody().getUserData() instanceof Animation[] || b.getBody().getUserData() instanceof Animation[]) && !this.player.invincible) {
            this.game.setToKillScreen("You got shot by the bowmen");
        }
    }

    @Override
    public void endContact(Contact contact) {
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }
}

