/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonReader
implements BaseJsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_indicies = JsonReader.init__json_indicies_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 27;
    static final int json_error = 0;
    static final int json_en_object = 5;
    static final int json_en_array = 19;
    static final int json_en_main = 1;
    private final Array<JsonValue> elements = new Array(8);
    private final Array<JsonValue> lastChild = new Array(8);
    private JsonValue root;
    private JsonValue current;

    public JsonValue parse(String json) {
        char[] data = json.toCharArray();
        return this.parse(data, 0, data.length);
    }

    public JsonValue parse(Reader reader) {
        try {
            int length;
            char[] data = new char[1024];
            int offset = 0;
            while ((length = reader.read(data, offset, data.length - offset)) != -1) {
                if (length == 0) {
                    char[] newData = new char[data.length * 2];
                    System.arraycopy(data, 0, newData, 0, data.length);
                    data = newData;
                    continue;
                }
                offset += length;
            }
            JsonValue jsonValue = this.parse(data, 0, offset);
            return jsonValue;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
    }

    @Override
    public JsonValue parse(InputStream input) {
        try {
            JsonValue jsonValue = this.parse(new InputStreamReader(input, "UTF-8"));
            return jsonValue;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            StreamUtils.closeQuietly(input);
        }
    }

    @Override
    public JsonValue parse(FileHandle file) {
        try {
            return this.parse(file.reader("UTF-8"));
        }
        catch (Exception ex) {
            throw new SerializationException("Error parsing file: " + file, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public JsonValue parse(char[] data, int offset, int length) {
        p = offset;
        eof = pe = length;
        top = 0;
        stack = new int[4];
        s = 0;
        names = new Array<String>(8);
        needsUnescape = false;
        stringIsName = false;
        stringIsUnquoted = false;
        parseRuntimeEx = null;
        debug = false;
        if (debug) {
            System.out.println();
        }
        try {
            cs = 1;
            top = 0;
            _trans = 0;
            _goto_targ = 0;
            block42: while (true) {
                switch (_goto_targ) {
                    case 0: {
                        if (p == pe) {
                            _goto_targ = 4;
                            continue block42;
                        }
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block42;
                        }
                    }
                    case 1: {
                        _keys = JsonReader._json_key_offsets[cs];
                        _trans = JsonReader._json_index_offsets[cs];
                        _klen = JsonReader._json_single_lengths[cs];
                        if (_klen <= 0) ** GOTO lbl47
                        _lower = _keys;
                        _upper = _keys + _klen - 1;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1);
                            if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                _upper = _mid - 1;
                                continue;
                            }
                            if (data[p] > JsonReader._json_trans_keys[_mid]) {
                                _lower = _mid + 1;
                                continue;
                            }
                            _trans += _mid - _keys;
                            ** GOTO lbl61
                        }
                        _keys += _klen;
                        _trans += _klen;
lbl47:
                        // 2 sources

                        if ((_klen = JsonReader._json_range_lengths[cs]) > 0) {
                            _lower = _keys;
                            _upper = _keys + (_klen << 1) - 2;
                            while (_upper >= _lower) {
                                _mid = _lower + (_upper - _lower >> 1 & -2);
                                if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                    _upper = _mid - 2;
                                    continue;
                                }
                                if (data[p] > JsonReader._json_trans_keys[_mid + 1]) {
                                    _lower = _mid + 2;
                                    continue;
                                }
                                _trans += _mid - _keys >> 1;
                                ** GOTO lbl61
                            }
                            _trans += _klen;
                        }
lbl61:
                        // 5 sources

                        _trans = JsonReader._json_indicies[_trans];
                        cs = JsonReader._json_trans_targs[_trans];
                        if (JsonReader._json_trans_actions[_trans] == 0) ** GOTO lbl218
                        _acts = JsonReader._json_trans_actions[_trans];
                        _nacts = JsonReader._json_actions[_acts++];
                        block45: while (_nacts-- > 0) {
                            switch (JsonReader._json_actions[_acts++]) {
                                case 0: {
                                    stringIsName = true;
                                    break;
                                }
                                case 1: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    if (needsUnescape) {
                                        value = this.unescape(value);
                                    }
                                    if (!stringIsName) ** GOTO lbl82
                                    stringIsName = false;
                                    if (debug) {
                                        System.out.println("name: " + value);
                                    }
                                    names.add(value);
                                    ** GOTO lbl115
lbl82:
                                    // 1 sources

                                    v0 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (!stringIsUnquoted) ** GOTO lbl112
                                    if (!value.equals("true")) ** GOTO lbl89
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=true");
                                    }
                                    this.bool(name, true);
                                    ** GOTO lbl115
lbl89:
                                    // 1 sources

                                    if (!value.equals("false")) ** GOTO lbl94
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=false");
                                    }
                                    this.bool(name, false);
                                    ** GOTO lbl115
lbl94:
                                    // 1 sources

                                    if (!value.equals("null")) ** GOTO lbl97
                                    this.string(name, null);
                                    ** GOTO lbl115
lbl97:
                                    // 1 sources

                                    if (value.indexOf(46) == -1) ** GOTO lbl105
                                    try {
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        this.number(name, Double.parseDouble(value));
                                        ** GOTO lbl115
                                    }
                                    catch (NumberFormatException ignored) {
                                        ** GOTO lbl112
                                    }
lbl105:
                                    // 1 sources

                                    try {
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        this.number(name, Long.parseLong(value));
                                        ** GOTO lbl115
                                    }
                                    catch (NumberFormatException ignored) {
                                        // empty catch block
                                    }
lbl112:
                                    // 3 sources

                                    if (debug) {
                                        System.out.println("string: " + name + "=" + value);
                                    }
                                    this.string(name, value);
lbl115:
                                    // 7 sources

                                    stringIsUnquoted = false;
                                    break;
                                }
                                case 2: {
                                    v1 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("startObject: " + name);
                                    }
                                    this.startObject(name);
                                    if (top == stack.length) {
                                        newStack = new int[stack.length * 2];
                                        System.arraycopy(stack, 0, newStack, 0, stack.length);
                                        stack = newStack;
                                    }
                                    stack[top++] = cs;
                                    cs = 5;
                                    _goto_targ = 2;
                                    continue block42;
                                }
                                case 3: {
                                    if (debug) {
                                        System.out.println("endObject");
                                    }
                                    this.pop();
                                    cs = stack[--top];
                                    _goto_targ = 2;
                                    continue block42;
                                }
                                case 4: {
                                    v2 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("startArray: " + name);
                                    }
                                    this.startArray(name);
                                    if (top == stack.length) {
                                        newStack = new int[stack.length * 2];
                                        System.arraycopy(stack, 0, newStack, 0, stack.length);
                                        stack = newStack;
                                    }
                                    stack[top++] = cs;
                                    cs = 19;
                                    _goto_targ = 2;
                                    continue block42;
                                }
                                case 5: {
                                    if (debug) {
                                        System.out.println("endArray");
                                    }
                                    this.pop();
                                    cs = stack[--top];
                                    _goto_targ = 2;
                                    continue block42;
                                }
                                case 6: {
                                    if (debug) {
                                        System.out.println("comment /" + data[p]);
                                    }
                                    if (data[p++] == '/') {
                                        while (data[p] != '\n') {
                                            ++p;
                                        }
                                        continue block45;
                                    }
                                    while (data[p] != '*' || data[p + 1] != '/') {
                                        ++p;
                                    }
                                    ++p;
                                    break;
                                }
                                case 7: {
                                    if (debug) {
                                        System.out.println("unquotedChars");
                                    }
                                    s = p;
                                    needsUnescape = false;
                                    stringIsUnquoted = true;
                                    if (!stringIsName) ** GOTO lbl188
                                    block48: while (true) {
                                        switch (data[p]) {
                                            case '\\': {
                                                needsUnescape = true;
                                                ** GOTO lbl184
                                            }
                                            case '\t': 
                                            case '\n': 
                                            case '\r': 
                                            case ' ': 
                                            case ':': {
                                                break block48;
                                            }
lbl184:
                                            // 2 sources

                                            default: {
                                                if (++p != eof) continue block48;
                                                break block48;
                                            }
                                        }
                                        break;
                                    }
                                    ** GOTO lbl198
lbl188:
                                    // 1 sources

                                    block49: while (true) {
                                        switch (data[p]) {
                                            case '\\': {
                                                needsUnescape = true;
                                                ** GOTO lbl195
                                            }
                                            case '\t': 
                                            case '\n': 
                                            case '\r': 
                                            case ' ': 
                                            case ',': 
                                            case ']': 
                                            case '}': {
                                                break block49;
                                            }
lbl195:
                                            // 2 sources

                                            default: {
                                                if (++p != eof) continue block49;
                                                break block49;
                                            }
                                        }
                                        break;
                                    }
lbl198:
                                    // 3 sources

                                    --p;
                                    break;
                                }
                                case 8: {
                                    if (debug) {
                                        System.out.println("quotedChars");
                                    }
                                    s = ++p;
                                    needsUnescape = false;
                                    block50: while (true) {
                                        switch (data[p]) {
                                            case '\\': {
                                                needsUnescape = true;
                                                ++p;
                                                ** GOTO lbl213
                                            }
                                            case '\"': {
                                                break block50;
                                            }
lbl213:
                                            // 2 sources

                                            default: {
                                                if (++p != eof) continue block50;
                                                break block50;
                                            }
                                        }
                                        break;
                                    }
                                    --p;
                                }
                            }
                        }
                    }
lbl218:
                    // 3 sources

                    case 2: {
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block42;
                        }
                        if (++p != pe) {
                            _goto_targ = 1;
                            continue block42;
                        }
                    }
                    case 4: {
                        if (p != eof) break block42;
                        __acts = JsonReader._json_eof_actions[cs];
                        __nacts = JsonReader._json_actions[__acts++];
                        while (__nacts-- > 0) {
                            switch (JsonReader._json_actions[__acts++]) {
                                case 1: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    if (needsUnescape) {
                                        value = this.unescape(value);
                                    }
                                    if (!stringIsName) ** GOTO lbl242
                                    stringIsName = false;
                                    if (debug) {
                                        System.out.println("name: " + value);
                                    }
                                    names.add(value);
                                    ** GOTO lbl275
lbl242:
                                    // 1 sources

                                    v3 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (!stringIsUnquoted) ** GOTO lbl272
                                    if (!value.equals("true")) ** GOTO lbl249
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=true");
                                    }
                                    this.bool(name, true);
                                    ** GOTO lbl275
lbl249:
                                    // 1 sources

                                    if (!value.equals("false")) ** GOTO lbl254
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=false");
                                    }
                                    this.bool(name, false);
                                    ** GOTO lbl275
lbl254:
                                    // 1 sources

                                    if (!value.equals("null")) ** GOTO lbl257
                                    this.string(name, null);
                                    ** GOTO lbl275
lbl257:
                                    // 1 sources

                                    if (value.indexOf(46) == -1) ** GOTO lbl265
                                    try {
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        this.number(name, Double.parseDouble(value));
                                        ** GOTO lbl275
                                    }
                                    catch (NumberFormatException ignored) {
                                        ** GOTO lbl272
                                    }
lbl265:
                                    // 1 sources

                                    try {
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        this.number(name, Long.parseLong(value));
                                        ** GOTO lbl275
                                    }
                                    catch (NumberFormatException ignored) {
                                        // empty catch block
                                    }
lbl272:
                                    // 3 sources

                                    if (debug) {
                                        System.out.println("string: " + name + "=" + value);
                                    }
                                    this.string(name, value);
lbl275:
                                    // 7 sources

                                    stringIsUnquoted = false;
                                }
                            }
                        }
                        break block42;
                    }
                }
                break;
            }
        }
        catch (RuntimeException ex) {
            parseRuntimeEx = ex;
        }
        root = this.root;
        this.root = null;
        this.current = null;
        this.lastChild.clear();
        if (p < pe) {
            lineNumber = 1;
            for (i = 0; i < p; ++i) {
                if (data[i] != '\n') continue;
                ++lineNumber;
            }
            throw new SerializationException("Error parsing JSON on line " + lineNumber + " near: " + new String(data, p, pe - p), parseRuntimeEx);
        }
        if (this.elements.size != 0) {
            element = this.elements.peek();
            this.elements.clear();
            if (element != null && element.isObject()) {
                throw new SerializationException("Error parsing JSON, unmatched brace.");
            }
            throw new SerializationException("Error parsing JSON, unmatched bracket.");
        }
        if (parseRuntimeEx != null) {
            throw new SerializationException("Error parsing JSON: " + new String(data), parseRuntimeEx);
        }
        return root;
    }

    private static byte[] init__json_actions_0() {
        return new byte[]{0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 2, 0, 7, 2, 0, 8, 2, 1, 3, 2, 1, 5};
    }

    private static short[] init__json_key_offsets_0() {
        return new short[]{0, 0, 12, 14, 15, 17, 29, 35, 41, 43, 55, 62, 69, 81, 82, 84, 86, 87, 89, 91, 103, 110, 117, 129, 130, 132, 134, 136, 141, 146, 146};
    }

    private static char[] init__json_trans_keys_0() {
        return new char[]{'\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '*', '/', '\"', '*', '/', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', '/', ':', '\t', '\n', '\r', ' ', '/', ':', '\t', '\n', '*', '/', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', ',', '/', '}', '\t', '\n', '\r', ' ', ',', '/', '}', '\t', '\n', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\"', '*', '/', '*', '/', '\"', '*', '/', '*', '/', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', ',', '/', ']', '\t', '\n', '\r', ' ', ',', '/', ']', '\t', '\n', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\"', '*', '/', '*', '/', '*', '/', '\r', ' ', '/', '\t', '\n', '\r', ' ', '/', '\t', '\n', '\u0000'};
    }

    private static byte[] init__json_single_lengths_0() {
        return new byte[]{0, 10, 2, 1, 2, 10, 4, 4, 2, 10, 5, 5, 10, 1, 2, 2, 1, 2, 2, 10, 5, 5, 10, 1, 2, 2, 2, 3, 3, 0, 0};
    }

    private static byte[] init__json_range_lengths_0() {
        return new byte[]{0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0};
    }

    private static short[] init__json_index_offsets_0() {
        return new short[]{0, 0, 12, 15, 17, 20, 32, 38, 44, 47, 59, 66, 73, 85, 87, 90, 93, 95, 98, 101, 113, 120, 127, 139, 141, 144, 147, 150, 155, 160, 161};
    }

    private static byte[] init__json_indicies_0() {
        return new byte[]{1, 1, 2, 3, 4, 3, 5, 3, 6, 3, 1, 0, 7, 7, 3, 8, 3, 9, 9, 3, 11, 11, 12, 13, 14, 3, 3, 3, 3, 15, 11, 10, 16, 16, 17, 18, 16, 3, 19, 19, 20, 21, 19, 3, 22, 22, 3, 21, 21, 24, 3, 25, 3, 26, 3, 27, 3, 21, 23, 28, 28, 29, 30, 31, 28, 3, 32, 32, 13, 33, 15, 32, 3, 13, 13, 12, 3, 34, 3, 3, 3, 3, 15, 13, 10, 16, 3, 35, 35, 3, 36, 36, 3, 28, 3, 37, 37, 3, 38, 38, 3, 40, 40, 41, 42, 43, 3, 44, 45, 46, 3, 40, 39, 47, 47, 48, 49, 50, 47, 3, 51, 51, 42, 52, 45, 51, 3, 42, 42, 41, 3, 53, 3, 44, 45, 46, 3, 42, 39, 47, 3, 54, 54, 3, 55, 55, 3, 56, 56, 3, 8, 8, 57, 8, 3, 58, 58, 59, 58, 3, 3, 3, 0};
    }

    private static byte[] init__json_trans_targs_0() {
        return new byte[]{27, 1, 3, 0, 4, 28, 28, 28, 28, 1, 6, 5, 13, 12, 18, 29, 7, 8, 9, 7, 8, 9, 7, 10, 16, 17, 11, 11, 11, 12, 15, 29, 11, 15, 14, 12, 11, 9, 5, 20, 19, 23, 22, 26, 21, 30, 21, 21, 22, 25, 30, 21, 25, 24, 22, 21, 19, 2, 28, 2};
    }

    private static byte[] init__json_trans_actions_0() {
        return new byte[]{13, 0, 15, 0, 0, 7, 3, 11, 1, 11, 17, 0, 20, 0, 0, 5, 1, 1, 1, 0, 0, 0, 11, 13, 15, 0, 7, 3, 1, 1, 1, 23, 0, 0, 0, 11, 11, 11, 11, 13, 0, 15, 0, 0, 7, 9, 3, 1, 1, 1, 26, 0, 0, 0, 11, 11, 11, 1, 0, 0};
    }

    private static byte[] init__json_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0};
    }

    private void addChild(String name, JsonValue child) {
        child.setName(name);
        if (this.current == null) {
            this.current = child;
            this.root = child;
        } else if (this.current.isArray() || this.current.isObject()) {
            if (this.current.size == 0) {
                this.current.child = child;
            } else {
                JsonValue last = this.lastChild.pop();
                last.next = child;
                child.prev = last;
            }
            this.lastChild.add(child);
            ++this.current.size;
        } else {
            this.root = this.current;
        }
    }

    protected void startObject(String name) {
        JsonValue value = new JsonValue(JsonValue.ValueType.object);
        if (this.current != null) {
            this.addChild(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void startArray(String name) {
        JsonValue value = new JsonValue(JsonValue.ValueType.array);
        if (this.current != null) {
            this.addChild(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void pop() {
        this.root = this.elements.pop();
        if (this.current.size > 0) {
            this.lastChild.pop();
        }
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }

    protected void string(String name, String value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void number(String name, double value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void number(String name, long value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void bool(String name, boolean value) {
        this.addChild(name, new JsonValue(value));
    }

    private String unescape(String value) {
        int length = value.length();
        StringBuilder buffer = new StringBuilder(length + 16);
        int i = 0;
        while (i < length) {
            char c;
            if ((c = value.charAt(i++)) != '\\') {
                buffer.append(c);
                continue;
            }
            if (i == length) break;
            if ((c = value.charAt(i++)) == 'u') {
                buffer.append(Character.toChars(Integer.parseInt(value.substring(i, i + 4), 16)));
                i += 4;
                continue;
            }
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                default: {
                    throw new SerializationException("Illegal escaped character: \\" + c);
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

